
-- Rain parameters
kPPS = 600;               -- Number of particles generated per second
kGravity = 700 ;            -- Gravity in pixels/second/second

-- kBlendNormal
-- kBlendOpaque
-- kBlendAdditive
-- kBlendAdditiveAlpha
-- kBlendSubtractive
-- kBlendLit

function Init()
  SetTexture("streamer");
  SetBlendMode(kBlendLit);
  SetNumParticles(8);
end

floor = math.floor

ParticlesPerSecond = NewParticleGenerator();

StopSpouting = NewTimeout(500);
TestDone = NewTimeout(2500);

function Update(ms)
  if (TestDone(ms)) then
    SetDone();
    return ;
  end
  local newParticles = ParticlesPerSecond( kPPS,ms );

  if (not StopSpouting(ms)) then
   InitPosition( "vRange", Vec3(-10,-10,0), Vec3(10,10,0) );
   InitVelocity( "vRange", Vec3(-100,-200,0), Vec3(100, -400, 0));
   InitScale( "fRange", 0.65, 1 );
   InitAge("iRange", 0, 0);
   InitExtra1("fRange",0,1);
   InitColor("cSelect",Color(0,.8,.8,1), Color(1,0,0,1), Color(1,1,0,1), Color(0,1,.2,1) );
   CreateParticles(1);
  end

  Gravity(kGravity);

   Do("move");
   DoAge("iAge");
   Do("expire", 2000)

   DoUp( "vRotate", -.1, .1 );


end

